C      *****************************************************************
C      * Subroutine Flop                                               *
C      * Calculate the the amount of components entering the first     *
C      * layer due to rainfall or throughfall (flux though the top).   *
C      *                                                               *
C      * Variables:                                                    *
C      * C         -Local - Component index.  Unitless.                *
C      * CatchArea -Input - A vector, of size NLayers, of the catchment*
C      *                    area for each layer.  Input from TREGRO, or*
C      *                    read into the model by the routine InParam.*
C      *                    Units are m**2.                            *
C      *                    (Common block VModel, file VModel.f)       *
C      * ElapT     -Input - The elapsed time since the last call, i.e.,*
C      *                    the model timestep.  (This is model time,  *
C      *                    not real time.)  Input from TREGRO, or read*
C      *                    into the model by the routine InParam.     *
C      *                    Units are s.                               *
C      *                    (Common block VModel, file VModel.f)       *
C      * MovComp   -Output- A matrix, of size NComp by NLayers+1,      *
C      *                    that contains the amount of each component *
C      *                    moved in each flux.  If the amount is      *
C      *                    positive the component moves from the layer*
C      *                    with the same number as the flux to layer  *
C      *                    flux+1.  If the amount is negative the     *
C      *                    component moves from layer flux to flux-1. *
C      *                    Units are mol.                             *
C      *                    (Common block VModel, file VModel.f)       *
C      * NComp     -Input - The number of components in the system.    *
C      *                    Unitless.                                  *
C      *                    (Common block VModel, file VModel.f)       *
C      * SType     -Input - A vector, of size NSpecies, of each        *
C      *                    species's type.  Unitless.                 *
C      *                    (Common block VModel, file VModel.f)       *
C      * TFConc    -Input - A vector, of size NComp, of throughfall    *
C      *                    concentrations.  The order of the          *
C      *                    components is the same as in SPConc.  Input*
C      *                    from TREGRO, or read into the model by the *
C      *                    routine InParam.  Units are mol/L.         *
C      *                    (Common block VModel, file VModel.f)       *
C      * WFlux     -Input - A vector, of size NLayers, of net water    *
C      *                    fluxes between layers.  Flux(0) is the net *
C      *                    flux between the atmosphere and the top    *
C      *                    layer, Flux(1) is the net flux between     *
C      *                    layers number 1 and 2, Flux(3) is the net  *
C      *                    flux between layers number 3 and 4.  If    *
C      *                    the flux is positive, the water is moving  *
C      *                    down; if the flux is negative, the water is*
C      *                    moving up.  Input from TREGRO, or read into*
C      *                    the model by the routine InParam.  Units   *
C      *                    are L/(m**2 sec).                          *                     
C      *                    (Common block VModel, file VModel.f)       *
C      *****************************************************************
       SUBROUTINE FLOP
							IMPLICIT NONE
							INCLUDE 'VMODEL.INC'
							INTEGER C

C      *--------------------------------------------------------------*
C      * The amount of aqueous components in the rainfall/throughfall *
C      * is calculated as the amount of water entering the top of the *
C      * soil column times the concentration of the component in that *
C      * water.                                                       *
C      *--------------------------------------------------------------*
       DO 100 C=1,NCOMP
	         IF (STYPE(C).LT.SPMASBAL) THEN
		           MOVCOMP(C,0) = WFLUX(0) * CATCHAREA(1) * ELAPT * 
     >                      TFCONC(C)
          ENDIF
  100  CONTINUE

       RETURN
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
